/******************************************************************************/
// Bullfrog Engine Emulation Library - for use to remake classic games like
// Syndicate Wars, Magic Carpet or Dungeon Keeper.
/******************************************************************************/
/** @file bflib_vidraw.h
 *     Header file for bflib_vidraw.c.
 * @par Purpose:
 *     Graphics canvas drawing library.
 * @par Comment:
 *     Just a header file - #defines, typedefs, function prototypes etc.
 * @author   Tomasz Lis
 * @date     12 Feb 2008 - 10 Jan 2009
 * @par  Copying and copyrights:
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 */
/******************************************************************************/
#ifndef BFLIB_VIDRAW_H
#define BFLIB_VIDRAW_H

#include "bflib_video.h"

#ifdef __cplusplus
extern "C" {
#endif
/******************************************************************************/
#define NUM_DRAWITEMS 238

typedef void __fastcall FlicFunc(void);

struct StartScreenPoint {
        short X;
        short Y;
};

//Note: this name is incorrect! (not from game)
struct LongPoint {
        long X;
        long Y;
};

struct EnginePoint {
        long X;
        long Y;
        long TMapX;
        long TMapY;
        long Shade;
        long X3d;
        long Y3d;
        long Z3d;
        long DistSqr;
        unsigned short padw;
        unsigned char Flags;
        unsigned char padb;
};

struct TbDItmHotspot {
        short X;
        short Y;
};

struct TbDItmFlic {
        FlicFunc *Function;
        TbPixel Colour;
};

struct TbDItmText {
        short WindowX;
        short WindowY;
        short Width;
        short Height;
        short X;
        short Y;
        const char *Text;
        struct TbSprite *Font;
        unsigned short Line;
        TbPixel Colour;
};

struct TbDItmSprite {
        short X;
        short Y;
        struct TbSprite *Sprite;
        TbPixel Colour;
};

struct TbDItmTrig {
        short X2;
        short Y2;
        short X3;
        short Y3;
        TbPixel Colour;
};

struct TbDItmTriangle {
        short X1;
        short Y1;
        short X2;
        short Y2;
        short X3;
        short Y3;
        TbPixel Colour;
};

struct TbDItmBox {
        short X;
        short Y;
        short Width;
        short Height;
        TbPixel Colour;
};

struct TbDItmLine {
        short X1;
        short Y1;
        short X2;
        short Y2;
        TbPixel Colour;
};

union TbDItmU {
        struct TbDItmTrig Trig;
        struct TbDItmTriangle Triangle;
        struct TbDItmBox Box;
        struct TbDItmLine Line;
        struct TbDItmSprite Sprite;
        struct TbDItmText Text;
        struct TbDItmFlic Flic;
        struct TbDItmHotspot Hotspot;
};

//Original size (incl. any padding) = 26 bytes
struct PurpleDrawItem {
        union TbDItmU U;
        // pos=23d
        unsigned char Type;
        // pos=24d
        unsigned short Flags;
};
/*
extern struct PurpleDrawItem *purple_draw_list;
extern unsigned short purple_draw_index;
extern TbSprite *lbFontPtr;
extern TbPixel vec_colour;
extern unsigned char vec_tmap[];
extern StartScreenPoint proj_origin;
extern unsigned short text_window_x1, text_window_y1;
extern unsigned short text_window_x2, text_window_y2;
extern char my_line_spacing;
*/
/******************************************************************************/
//Routines to be moved into bflib_vipurp
/*
void __fastcall draw_box_purple_list(const long x, const long y, const unsigned long width, const unsigned long height, const TbPixel colour);
void __fastcall copy_box_purple_list(const long x, const long y, const unsigned long width, const unsigned long height);
void __fastcall my_set_text_window(const unsigned short x1, const unsigned short y1,
        const unsigned short width, const unsigned short height);
void __fastcall draw_text_purple_list(const long x, const long y, const char *text, const int line);
void __fastcall draw_sprite_purple_list(long x, long y, struct TbSprite *sprite);
void __fastcall draw_trig_purple_list(long x2, long y2, long x3, long y3);
void __fastcall  draw_triangle_purple_list(long x1, long y1, long x2, long y2,
        long x3, long y3, TbPixel colour);
void __fastcall draw_line_purple_list(long x1, long y1, long x2, long y2, TbPixel colour);
void __fastcall draw_flic_purple_list(FlicFunc *fn);
void __fastcall draw_hotspot_purple_list(long x, long y);
unsigned short __fastcall my_draw_text(long x, long y, const char *text, const long startline);
void __fastcall draw_purple_screen(void);
*/
/******************************************************************************/
int LbDrawBox(long x, long y, unsigned long width, unsigned long height, TbPixel colour);
void LbDrawHVLine(long xpos1, long ypos1, long xpos2, long ypos2, TbPixel colour);
int LbSpriteDraw(long x, long y, struct TbSprite *spr);
int LbSpriteDrawRemap(long x, long y, struct TbSprite *spr,unsigned char *map);
/*
int __fastcall LbDrawBoxCoords(long xpos1, long ypos1, long xpos2, long ypos2, TbPixel colour);

int __fastcall LbSpriteDrawScaled(long xpos, long ypos, struct TbSprite *sprite, long dest_width, long dest_height);
int __fastcall LbSpriteDrawOneColour(long x, long y, struct TbSprite *spr, TbPixel colour);
char __fastcall LbDrawLine(long x1, long y1, long x2, long y2, TbPixel colour);
void __fastcall LbDrawTriangle(long x1, long y1, long x2, long y2, long x3, long y3, TbPixel colour);
*/
/******************************************************************************/
#ifdef __cplusplus
}
#endif
#endif
