/******************************************************************************/
// Free implementation of Bullfrog's Dungeon Keeper strategy game.
/******************************************************************************/
/** @file frontend.h
 *     Header file for frontend.c.
 * @par Purpose:
 *     Functions to display and maintain the game menu.
 * @par Comment:
 *     Just a header file - #defines, typedefs, function prototypes etc.
 * @author   Tomasz Lis
 * @date     10 Nov 2008 - 01 Feb 2009
 * @par  Copying and copyrights:
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 */
/******************************************************************************/
#ifndef DK_FRONTEND_H
#define DK_FRONTEND_H

#include "globals.h"
#include "bflib_guibtns.h"

struct GuiMenu;
struct GuiButton;

#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************/
// Limits for GUI arrays
#define ACTIVE_BUTTONS_COUNT 86
#define ACTIVE_MENUS_COUNT 8
// Sprite limits
#define PANEL_SPRITES_COUNT 514
// Positioning constants for menus
#define POS_AUTO -9999
#define POS_MOUSMID -999
#define POS_MOUSPRV -998
#define POS_SCRCTR  -997
#define POS_SCRBTM  -996
#define POS_GAMECTR  999
// After that much miliseconds in main menu, demo is started
#define MNU_DEMO_IDLE_TIME 30000
/******************************************************************************/
enum DemoItem_Kind {
    DIK_PlaySmkVideo,
    DIK_LoadPacket,
    DIK_SwitchState,
    DIK_ListEnd,
};

#ifdef __cplusplus
#pragma pack(1)
#endif

struct DemoItem { //sizeof = 5
    unsigned char numfield_0;
    const char *fname;
};

struct HighScore {
        long score;
        char name[64];
        long level;
};

#ifdef __cplusplus
#pragma pack()
#endif
/******************************************************************************/
DLLIMPORT struct GuiButtonInit _DK_main_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_room_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_spell_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_spell_lost_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_trap_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_creature_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_event_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_options_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_query_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_instance_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_quit_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_load_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_save_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_video_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_sound_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_error_box_buttons[];
DLLIMPORT struct GuiButtonInit _DK_text_info_buttons[];
DLLIMPORT struct GuiButtonInit _DK_pause_buttons[];
DLLIMPORT struct GuiButtonInit _DK_hold_audience_buttons[];
DLLIMPORT struct GuiButtonInit _DK_armageddon_buttons[];
DLLIMPORT struct GuiButtonInit _DK_dungeon_special_buttons[];
DLLIMPORT struct GuiButtonInit _DK_battle_buttons[];
DLLIMPORT struct GuiButtonInit _DK_resurrect_creature_buttons[];
DLLIMPORT struct GuiButtonInit _DK_transfer_creature_buttons[];
DLLIMPORT struct GuiButtonInit _DK_frontend_main_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_frontend_load_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_frontend_net_service_buttons[];
DLLIMPORT struct GuiButtonInit _DK_frontend_net_session_buttons[];
DLLIMPORT struct GuiButtonInit _DK_frontend_net_start_buttons[];
DLLIMPORT struct GuiButtonInit _DK_frontend_net_modem_buttons[37];
DLLIMPORT struct GuiButtonInit _DK_frontend_net_serial_buttons[22];
DLLIMPORT struct GuiButtonInit _DK_frontend_statistics_buttons[];
DLLIMPORT struct GuiButtonInit _DK_frontend_high_score_score_buttons[];
DLLIMPORT struct GuiButtonInit _DK_creature_query_buttons1[];
DLLIMPORT struct GuiButtonInit _DK_creature_query_buttons2[];
DLLIMPORT struct GuiButtonInit _DK_creature_query_buttons3[];
DLLIMPORT struct GuiButtonInit _DK_frontend_define_keys_buttons[];
DLLIMPORT struct GuiButtonInit _DK_autopilot_menu_buttons[];
DLLIMPORT struct GuiButtonInit _DK_frontend_option_buttons[];
DLLIMPORT struct GuiMenu _DK_main_menu;
DLLIMPORT struct GuiMenu _DK_room_menu;
DLLIMPORT struct GuiMenu _DK_spell_menu;
DLLIMPORT struct GuiMenu _DK_spell_lost_menu;
DLLIMPORT struct GuiMenu _DK_trap_menu;
DLLIMPORT struct GuiMenu _DK_creature_menu;
DLLIMPORT struct GuiMenu _DK_event_menu;
DLLIMPORT struct GuiMenu _DK_options_menu;
DLLIMPORT struct GuiMenu _DK_instance_menu;
DLLIMPORT struct GuiMenu _DK_query_menu;
DLLIMPORT struct GuiMenu _DK_quit_menu;
DLLIMPORT struct GuiMenu _DK_load_menu;
DLLIMPORT struct GuiMenu _DK_save_menu;
DLLIMPORT struct GuiMenu _DK_video_menu;
DLLIMPORT struct GuiMenu _DK_sound_menu;
DLLIMPORT struct GuiMenu _DK_error_box;
DLLIMPORT struct GuiMenu _DK_text_info_menu;
DLLIMPORT struct GuiMenu _DK_hold_audience_menu;
DLLIMPORT struct GuiMenu _DK_dungeon_special_menu;
DLLIMPORT struct GuiMenu _DK_resurrect_creature_menu;
DLLIMPORT struct GuiMenu _DK_transfer_creature_menu;
DLLIMPORT struct GuiMenu _DK_armageddon_menu;
DLLIMPORT struct GuiMenu _DK_frontend_main_menu;
DLLIMPORT struct GuiMenu _DK_frontend_load_menu;
DLLIMPORT struct GuiMenu _DK_frontend_net_service_menu;
DLLIMPORT struct GuiMenu _DK_frontend_net_session_menu;
DLLIMPORT struct GuiMenu _DK_frontend_net_start_menu;
DLLIMPORT struct GuiMenu _DK_frontend_net_modem_menu;
DLLIMPORT struct GuiMenu _DK_frontend_net_serial_menu;
DLLIMPORT struct GuiMenu _DK_frontend_statistics_menu;
DLLIMPORT struct GuiMenu _DK_frontend_high_score_table_menu;
DLLIMPORT struct GuiMenu _DK_creature_query_menu1;
DLLIMPORT struct GuiMenu _DK_creature_query_menu2;
DLLIMPORT struct GuiMenu _DK_creature_query_menu3;
DLLIMPORT struct GuiMenu _DK_battle_menu;
DLLIMPORT struct GuiMenu _DK_frontend_define_keys_menu;
DLLIMPORT struct GuiMenu _DK_autopilot_menu;
DLLIMPORT struct GuiMenu _DK_frontend_option_menu;
DLLIMPORT struct GuiMenu *_DK_menu_list[40];

DLLIMPORT char _DK_info_tag;
#define info_tag _DK_info_tag
DLLIMPORT char _DK_room_tag;
#define room_tag _DK_room_tag
DLLIMPORT char _DK_spell_tag;
#define spell_tag _DK_spell_tag
DLLIMPORT char _DK_trap_tag;
#define trap_tag _DK_trap_tag
DLLIMPORT char _DK_creature_tag;
#define creature_tag _DK_creature_tag
DLLIMPORT char _DK_input_string[8][16];
#define input_string _DK_input_string
DLLIMPORT extern struct ToolTipBox _DK_tool_tip_box;
#define tool_tip_box _DK_tool_tip_box
DLLIMPORT char _DK_gui_error_text[256];
#define gui_error_text _DK_gui_error_text
DLLIMPORT long _DK_net_service_scroll_offset;
#define net_service_scroll_offset _DK_net_service_scroll_offset
DLLIMPORT long _DK_net_number_of_services;
#define net_number_of_services _DK_net_number_of_services
DLLIMPORT extern struct TbSprite *_DK_frontend_font[4];
#define frontend_font _DK_frontend_font
DLLIMPORT char _DK_no_of_active_menus;
#define no_of_active_menus _DK_no_of_active_menus
DLLIMPORT unsigned char _DK_menu_stack[ACTIVE_MENUS_COUNT];
#define menu_stack _DK_menu_stack
DLLIMPORT extern struct GuiButton _DK_active_buttons[ACTIVE_BUTTONS_COUNT];
#define active_buttons _DK_active_buttons
DLLIMPORT long _DK_frontend_mouse_over_button_start_time;
#define frontend_mouse_over_button_start_time _DK_frontend_mouse_over_button_start_time
DLLIMPORT extern struct TbSprite *_DK_frontend_sprite;
#define frontend_sprite _DK_frontend_sprite
DLLIMPORT short _DK_old_menu_mouse_x;
#define old_menu_mouse_x _DK_old_menu_mouse_x
DLLIMPORT short _DK_old_menu_mouse_y;
#define old_menu_mouse_y _DK_old_menu_mouse_y
DLLIMPORT unsigned char _DK_menu_ids[3];
#define menu_ids _DK_menu_ids
DLLIMPORT struct EventTypeInfo _DK_event_button_info[27];
#define event_button_info _DK_event_button_info
DLLIMPORT unsigned char _DK_new_objective;
#define new_objective _DK_new_objective
DLLIMPORT char _DK_gui_error_text[256];
#define gui_error_text _DK_gui_error_text
DLLIMPORT extern int _DK_frontend_menu_state;
#define frontend_menu_state _DK_frontend_menu_state
DLLIMPORT extern long _DK_credits_scroll_speed;
#define credits_scroll_speed _DK_credits_scroll_speed
DLLIMPORT extern long _DK_credits_offset;
#define credits_offset _DK_credits_offset
DLLIMPORT extern int _DK_load_game_scroll_offset;
#define load_game_scroll_offset _DK_load_game_scroll_offset
DLLIMPORT extern unsigned char *_DK_frontend_background;
#define frontend_background _DK_frontend_background
DLLIMPORT extern struct HighScore _DK_high_score_table[10];
#define high_score_table _DK_high_score_table
DLLIMPORT extern long _DK_high_score_entry_input_active;
#define high_score_entry_input_active _DK_high_score_entry_input_active
DLLIMPORT extern long _DK_high_score_entry_index;
#define high_score_entry_index _DK_high_score_entry_index
DLLIMPORT extern char _DK_high_score_entry[64];
#define high_score_entry _DK_high_score_entry
/******************************************************************************/
// Variables - no linger imported
extern struct GuiMenu main_menu;
extern struct GuiMenu room_menu;
extern struct GuiMenu spell_menu;
extern struct GuiMenu spell_lost_menu;
extern struct GuiMenu trap_menu;
extern struct GuiMenu creature_menu;
extern struct GuiMenu event_menu;
extern struct GuiMenu options_menu;
extern struct GuiMenu instance_menu;
extern struct GuiMenu query_menu;
extern struct GuiMenu quit_menu;
extern struct GuiMenu load_menu;
extern struct GuiMenu save_menu;
extern struct GuiMenu video_menu;
extern struct GuiMenu sound_menu;
extern struct GuiMenu error_box;
extern struct GuiMenu text_info_menu;
extern struct GuiMenu hold_audience_menu;
extern struct GuiMenu dungeon_special_menu;
extern struct GuiMenu resurrect_creature_menu;
extern struct GuiMenu transfer_creature_menu;
extern struct GuiMenu armageddon_menu;
extern struct GuiMenu frontend_main_menu;
extern struct GuiMenu frontend_load_menu;
extern struct GuiMenu frontend_net_service_menu;
extern struct GuiMenu frontend_net_session_menu;
extern struct GuiMenu frontend_net_start_menu;
extern struct GuiMenu frontend_net_modem_menu;
extern struct GuiMenu frontend_net_serial_menu;
extern struct GuiMenu frontend_statistics_menu;
extern struct GuiMenu frontend_high_score_table_menu;
extern struct GuiMenu creature_query_menu1;
extern struct GuiMenu creature_query_menu2;
extern struct GuiMenu creature_query_menu3;
extern struct GuiMenu battle_menu;
extern struct GuiMenu frontend_define_keys_menu;
extern struct GuiMenu autopilot_menu;
extern struct GuiMenu frontend_option_menu;
extern struct FrontEndButtonData frontend_button_info[];
extern struct GuiBoxOption gui_main_cheat_list[];
extern struct GuiBoxOption gui_creature_cheat_option_list[];
extern struct GuiBoxOption gui_instance_option_list[];

extern struct GuiMenu *menu_list[40];

/******************************************************************************/

DLLIMPORT char _DK_get_button_area_input(struct GuiButton *gbtn, int);
DLLIMPORT void _DK_setup_gui_tooltip(struct GuiButton *gbtn);

/******************************************************************************/
// Reworked functions

short check_if_mouse_is_over_button(struct GuiButton *gbtn);
void gui_area_text(struct GuiButton *gbtn);
void menu_tab_maintain(struct GuiButton *gbtn);
void maintain_turn_on_autopilot(struct GuiButton *gbtn);
void maintain_room(struct GuiButton *gbtn);
void maintain_big_room(struct GuiButton *gbtn);
void maintain_spell(struct GuiButton *gbtn);
void maintain_big_spell(struct GuiButton *gbtn);
void maintain_trap(struct GuiButton *gbtn);
void maintain_door(struct GuiButton *gbtn);
void maintain_big_trap(struct GuiButton *gbtn);
void maintain_activity_up(struct GuiButton *gbtn);
void maintain_activity_down(struct GuiButton *gbtn);
void maintain_activity_pic(struct GuiButton *gbtn);
void maintain_activity_row(struct GuiButton *gbtn);
void maintain_loadsave(struct GuiButton *gbtn);
void maintain_prison_bar(struct GuiButton *gbtn);
void maintain_room_and_creature_button(struct GuiButton *gbtn);
void maintain_ally(struct GuiButton *gbtn);
void gui_load_game_maintain(struct GuiButton *gbtn);
void gui_video_cluedo_maintain(struct GuiButton *gbtn);
void maintain_zoom_to_event(struct GuiButton *gbtn);
void maintain_scroll_up(struct GuiButton *gbtn);
void maintain_scroll_down(struct GuiButton *gbtn);
void maintain_resurrect_creature_select(struct GuiButton *gbtn);
void maintain_resurrect_creature_scroll(struct GuiButton *gbtn);
void maintain_transfer_creature_select(struct GuiButton *gbtn);
void maintain_transfer_creature_scroll(struct GuiButton *gbtn);
void frontend_continue_game_maintain(struct GuiButton *gbtn);
void frontend_main_menu_load_game_maintain(struct GuiButton *gbtn);
void frontend_main_menu_netservice_maintain(struct GuiButton *gbtn);
void frontend_main_menu_highscores_maintain(struct GuiButton *gbtn);
void frontend_load_game_up_maintain(struct GuiButton *gbtn);
void frontend_load_game_down_maintain(struct GuiButton *gbtn);
void frontnet_session_up_maintain(struct GuiButton *gbtn);
void frontnet_session_down_maintain(struct GuiButton *gbtn);
void frontnet_session_maintain(struct GuiButton *gbtn);
void frontnet_players_up_maintain(struct GuiButton *gbtn);
void frontnet_players_down_maintain(struct GuiButton *gbtn);
void frontnet_join_game_maintain(struct GuiButton *gbtn);
void frontnet_maintain_alliance(struct GuiButton *gbtn);
void frontnet_messages_up_maintain(struct GuiButton *gbtn);
void frontnet_messages_down_maintain(struct GuiButton *gbtn);
void frontnet_start_game_maintain(struct GuiButton *gbtn);
void frontnet_comport_up_maintain(struct GuiButton *gbtn);
void frontnet_comport_down_maintain(struct GuiButton *gbtn);
void frontnet_comport_select_maintain(struct GuiButton *gbtn);
void frontnet_comport_select_maintain(struct GuiButton *gbtn);
void frontnet_speed_up_maintain(struct GuiButton *gbtn);
void frontnet_speed_down_maintain(struct GuiButton *gbtn);
void frontnet_speed_select_maintain(struct GuiButton *gbtn);
void frontnet_speed_select_maintain(struct GuiButton *gbtn);
void frontnet_net_modem_start_maintain(struct GuiButton *gbtn);
void frontnet_comport_up_maintain(struct GuiButton *gbtn);
void frontnet_comport_down_maintain(struct GuiButton *gbtn);
void frontnet_comport_select_maintain(struct GuiButton *gbtn);
void frontnet_comport_select_maintain(struct GuiButton *gbtn);
void frontnet_speed_up_maintain(struct GuiButton *gbtn);
void frontnet_speed_down_maintain(struct GuiButton *gbtn);
void frontnet_speed_select_maintain(struct GuiButton *gbtn);
void frontnet_net_serial_start_maintain(struct GuiButton *gbtn);
void frontend_maintain_high_score_ok_button(struct GuiButton *gbtn);
void maintain_instance(struct GuiButton *gbtn);
void frontend_define_key_up_maintain(struct GuiButton *gbtn);
void frontend_define_key_down_maintain(struct GuiButton *gbtn);
void frontend_define_key_maintain(struct GuiButton *gbtn);
void gui_zoom_in(struct GuiButton *gbtn);
void gui_zoom_out(struct GuiButton *gbtn);
void gui_go_to_map(struct GuiButton *gbtn);
void gui_area_new_normal_button(struct GuiButton *gbtn);
void gui_area_autopilot_button(struct GuiButton *gbtn);
void gui_set_menu_mode(struct GuiButton *gbtn);
void gui_draw_tab(struct GuiButton *gbtn);
void gui_open_event(struct GuiButton *gbtn);
void gui_kill_event(struct GuiButton *gbtn);
void gui_area_event_button(struct GuiButton *gbtn);
void gui_choose_room(struct GuiButton *gbtn);
void gui_go_to_next_room(struct GuiButton *gbtn);
void gui_over_room_button(struct GuiButton *gbtn);
void gui_area_room_button(struct GuiButton *gbtn);
void gui_area_new_null_button(struct GuiButton *gbtn);
void gui_area_new_no_anim_button(struct GuiButton *gbtn);
void gui_remove_area_for_rooms(struct GuiButton *gbtn);
void gui_area_big_room_button(struct GuiButton *gbtn);
void gui_choose_spell(struct GuiButton *gbtn);
void gui_go_to_next_spell(struct GuiButton *gbtn);
void gui_area_spell_button(struct GuiButton *gbtn);
void gui_choose_special_spell(struct GuiButton *gbtn);
void gui_area_big_spell_button(struct GuiButton *gbtn);
void gui_choose_trap(struct GuiButton *gbtn);
void gui_go_to_next_trap(struct GuiButton *gbtn);
void gui_over_trap_button(struct GuiButton *gbtn);
void maintain_trap(struct GuiButton *gbtn);
void gui_area_trap_button(struct GuiButton *gbtn);
void gui_go_to_next_door(struct GuiButton *gbtn);
void maintain_door(struct GuiButton *gbtn);
void gui_over_door_button(struct GuiButton *gbtn);
void gui_remove_area_for_traps(struct GuiButton *gbtn);
void gui_area_big_trap_button(struct GuiButton *gbtn);
void maintain_big_trap(struct GuiButton *gbtn);
void gui_area_no_anim_button(struct GuiButton *gbtn);
void maintain_loadsave(struct GuiButton *gbtn);
void gui_area_normal_button(struct GuiButton *gbtn);
void gui_area_new_normal_button(struct GuiButton *gbtn);
void gui_set_tend_to(struct GuiButton *gbtn);
void gui_area_flash_cycle_button(struct GuiButton *gbtn);
void maintain_prison_bar(struct GuiButton *gbtn);
void gui_area_flash_cycle_button(struct GuiButton *gbtn);
void gui_set_query(struct GuiButton *gbtn);
void gui_area_payday_button(struct GuiButton *gbtn);
void gui_area_research_bar(struct GuiButton *gbtn);
void gui_area_workshop_bar(struct GuiButton *gbtn);
void gui_area_player_creature_info(struct GuiButton *gbtn);
void maintain_room_and_creature_button(struct GuiButton *gbtn);
void gui_area_player_room_info(struct GuiButton *gbtn);
void gui_toggle_ally(struct GuiButton *gbtn);
void maintain_ally(struct GuiButton *gbtn);
void gui_quit_game(struct GuiButton *gbtn);
void gui_area_ally(struct GuiButton *gbtn);
void gui_save_game(struct GuiButton *gbtn);
void gui_video_shadows(struct GuiButton *gbtn);
void gui_video_view_distance_level(struct GuiButton *gbtn);
void gui_video_rotate_mode(struct GuiButton *gbtn);
void gui_video_cluedo_mode(struct GuiButton *gbtn);
void gui_video_gamma_correction(struct GuiButton *gbtn);
void gui_set_sound_volume(struct GuiButton *gbtn);
void gui_set_music_volume(struct GuiButton *gbtn);
void gui_video_cluedo_maintain(struct GuiButton *gbtn);
void gui_area_slider(struct GuiButton *gbtn);
void gui_area_smiley_anger_button(struct GuiButton *gbtn);
void gui_area_experience_button(struct GuiButton *gbtn);
void gui_area_instance_button(struct GuiButton *gbtn);
void maintain_instance(struct GuiButton *gbtn);
void gui_area_stat_button(struct GuiButton *gbtn);
void frontend_define_key_up(struct GuiButton *gbtn);
void frontend_define_key_down(struct GuiButton *gbtn);
void frontend_define_key(struct GuiButton *gbtn);
void frontend_define_key_up_maintain(struct GuiButton *gbtn);
void frontend_define_key_down_maintain(struct GuiButton *gbtn);
void frontend_define_key_maintain(struct GuiButton *gbtn);
void frontend_draw_define_key_scroll_tab(struct GuiButton *gbtn);
void frontend_draw_define_key(struct GuiButton *gbtn);
void frontend_draw_icon(struct GuiButton *gbtn);
void frontend_draw_slider(struct GuiButton *gbtn);
void frontend_set_mouse_sensitivity(struct GuiButton *gbtn);
void frontend_draw_small_slider(struct GuiButton *gbtn);
void frontend_invert_mouse(struct GuiButton *gbtn);
void frontend_draw_invert_mouse(struct GuiButton *gbtn);
void frontstats_draw_main_stats(struct GuiButton *gbtn);
void frontstats_draw_scrolling_stats(struct GuiButton *gbtn);
void frontstats_leave(struct GuiButton *gbtn);
void frontend_draw_vlarge_menu_button(struct GuiButton *gbtn);
void frontend_draw_high_score_table(struct GuiButton *gbtn);
void frontend_quit_high_score_table(struct GuiButton *gbtn);
void frontend_maintain_high_score_ok_button(struct GuiButton *gbtn);

void pick_up_next_wanderer(struct GuiButton *gbtn);
void gui_go_to_next_wanderer(struct GuiButton *gbtn);
void pick_up_next_worker(struct GuiButton *gbtn);
void gui_go_to_next_worker(struct GuiButton *gbtn);
void pick_up_next_fighter(struct GuiButton *gbtn);
void gui_go_to_next_fighter(struct GuiButton *gbtn);
void gui_scroll_activity_up(struct GuiButton *gbtn);
void gui_scroll_activity_up(struct GuiButton *gbtn);
void gui_scroll_activity_down(struct GuiButton *gbtn);
void gui_scroll_activity_down(struct GuiButton *gbtn);
void maintain_activity_up(struct GuiButton *gbtn);
void maintain_activity_down(struct GuiButton *gbtn);
void maintain_activity_pic(struct GuiButton *gbtn);
void pick_up_next_creature(struct GuiButton *gbtn);
void gui_go_to_next_creature(struct GuiButton *gbtn);
void pick_up_creature_doing_activity(struct GuiButton *gbtn);
void gui_go_to_next_creature_activity(struct GuiButton *gbtn);
void gui_area_anger_button(struct GuiButton *gbtn);
void maintain_activity_row(struct GuiButton *gbtn);

void gui_activity_background(struct GuiMenu *gmnu);
void gui_pretty_background(struct GuiMenu *gmnu);
void gui_round_glass_background(struct GuiMenu *gmnu);
void gui_creature_query_background1(struct GuiMenu *gmnu);
void gui_creature_query_background2(struct GuiMenu *gmnu);
void reset_scroll_window(struct GuiMenu *gmnu);
void init_load_menu(struct GuiMenu *gmnu);
void init_save_menu(struct GuiMenu *gmnu);
void init_video_menu(struct GuiMenu *gmnu);
void init_audio_menu(struct GuiMenu *gmnu);
void frontmap_unload(void);
int frontend_load_data(void);
void frontnet_serial_reset(void);
void frontnet_modem_reset(void);
void fronttorture_unload(void);
void fronttorture_load(void);
void frontnetmap_unload(void);
void frontnetmap_load(void);
int frontmap_load(void);
void frontnet_service_setup(void);
void frontnet_session_setup(void);
void frontnet_start_setup(void);
void frontnet_modem_setup(void);
void frontnet_serial_setup(void);
void frontstats_set_timer(void);
void frontnet_start_input(void);
void frontend_high_score_table_input(void);
void frontmap_input(void);
void frontnetmap_input(void);
void fronttorture_input(void);
void frontmap_draw(void);
void frontcredits_draw(void);
void fronttorture_draw(void);
void frontnetmap_draw(void);
long frontmap_update(void);
long frontnetmap_update(void);
void frontstats_update(void);
void fronttorture_update(void);
void frontend_init_options_menu(struct GuiMenu *gmnu);
void frontend_draw_large_menu_button(struct GuiButton *gbtn);
void frontnet_draw_scroll_box_tab(struct GuiButton *gbtn);
void frontnet_draw_scroll_box(struct GuiButton *gbtn);
void frontnet_draw_slider_button(struct GuiButton *gbtn);
void frontnet_draw_services_scroll_tab(struct GuiButton *gbtn);
void frontend_draw_text(struct GuiButton *gbtn);
void frontnet_draw_service_button(struct GuiButton *gbtn);
void frontend_draw_large_menu_button(struct GuiButton *gbtn);
void frontnet_service_maintain(struct GuiButton *gbtn);
void frontnet_service_up_maintain(struct GuiButton *gbtn);
void frontnet_service_down_maintain(struct GuiButton *gbtn);
void frontnet_service_up(struct GuiButton *gbtn);
void frontnet_service_down(struct GuiButton *gbtn);
void frontnet_service_select(struct GuiButton *gbtn);
void frontend_change_state(struct GuiButton *gbtn);
void frontend_over_button(struct GuiButton *gbtn);
void frontnet_session_set_player_name(struct GuiButton *gbtn);
void frontnet_draw_text_bar(struct GuiButton *gbtn);
void frontend_draw_enter_text(struct GuiButton *gbtn);
void frontnet_session_up(struct GuiButton *gbtn);
void frontnet_session_up_maintain(struct GuiButton *gbtn);
void frontnet_session_down(struct GuiButton *gbtn);
void frontnet_session_down_maintain(struct GuiButton *gbtn);
void frontnet_session_maintain(struct GuiButton *gbtn);
void frontnet_draw_sessions_scroll_tab(struct GuiButton *gbtn);
void frontnet_draw_session_selected(struct GuiButton *gbtn);
void frontnet_session_select(struct GuiButton *gbtn);
void frontnet_draw_session_button(struct GuiButton *gbtn);
void frontnet_players_up(struct GuiButton *gbtn);
void frontnet_players_up_maintain(struct GuiButton *gbtn);
void frontnet_players_down(struct GuiButton *gbtn);
void frontnet_players_down_maintain(struct GuiButton *gbtn);
void frontnet_draw_players_scroll_tab(struct GuiButton *gbtn);
void frontnet_draw_net_session_players(struct GuiButton *gbtn);
void frontnet_session_join(struct GuiButton *gbtn);
void frontnet_session_create(struct GuiButton *gbtn);
void frontnet_return_to_main_menu(struct GuiButton *gbtn);
void frontend_draw_small_menu_button(struct GuiButton *gbtn);
void frontnet_join_game_maintain(struct GuiButton *gbtn);
void frontnet_draw_alliance_box_tab(struct GuiButton *gbtn);
void frontnet_draw_net_start_players(struct GuiButton *gbtn);
void frontnet_select_alliance(struct GuiButton *gbtn);
void frontnet_draw_alliance_grid(struct GuiButton *gbtn);
void frontnet_draw_alliance_button(struct GuiButton *gbtn);
void frontnet_maintain_alliance(struct GuiButton *gbtn);
void frontnet_messages_up(struct GuiButton *gbtn);
void frontnet_messages_up_maintain(struct GuiButton *gbtn);
void frontnet_messages_down(struct GuiButton *gbtn);
void frontnet_messages_down_maintain(struct GuiButton *gbtn);
void frontnet_draw_bottom_scroll_box_tab(struct GuiButton *gbtn);
void frontend_toggle_computer_players(struct GuiButton *gbtn);
void frontend_draw_computer_players(struct GuiButton *gbtn);
void frontnet_draw_messages_scroll_tab(struct GuiButton *gbtn);
void frontnet_draw_current_message(struct GuiButton *gbtn);
void frontnet_draw_messages(struct GuiButton *gbtn);
void set_packet_start(struct GuiButton *gbtn);
void frontnet_start_game_maintain(struct GuiButton *gbtn);
void frontnet_return_to_session_menu(struct GuiButton *gbtn);
void frontnet_draw_small_scroll_box_tab(struct GuiButton *gbtn);
void frontnet_draw_small_scroll_box(struct GuiButton *gbtn);
void frontnet_comport_up(struct GuiButton *gbtn);
void frontnet_comport_up_maintain(struct GuiButton *gbtn);
void frontnet_comport_down(struct GuiButton *gbtn);
void frontnet_comport_down_maintain(struct GuiButton *gbtn);
void frontnet_draw_comport_scroll_tab(struct GuiButton *gbtn);
void frontnet_draw_comport_selected(struct GuiButton *gbtn);
void frontnet_comport_select(struct GuiButton *gbtn);
void frontnet_draw_comport_button(struct GuiButton *gbtn);
void frontnet_comport_select_maintain(struct GuiButton *gbtn);
void frontnet_speed_up(struct GuiButton *gbtn);
void frontnet_speed_up_maintain(struct GuiButton *gbtn);
void frontnet_speed_down(struct GuiButton *gbtn);
void frontnet_speed_down_maintain(struct GuiButton *gbtn);
void frontnet_draw_speed_scroll_tab(struct GuiButton *gbtn);
void frontnet_draw_speed_selected(struct GuiButton *gbtn);
void frontnet_speed_select(struct GuiButton *gbtn);
void frontnet_draw_speed_button(struct GuiButton *gbtn);
void frontnet_speed_select_maintain(struct GuiButton *gbtn);
void frontnet_draw_text_cont_bar(struct GuiButton *gbtn);
void frontnet_net_set_modem_init(struct GuiButton *gbtn);
void frontnet_net_set_modem_hangup(struct GuiButton *gbtn);
void frontnet_net_set_modem_dial(struct GuiButton *gbtn);
void frontnet_net_set_phone_number(struct GuiButton *gbtn);
void frontnet_net_modem_start(struct GuiButton *gbtn);
void frontnet_net_modem_start_maintain(struct GuiButton *gbtn);
void frontnet_net_set_modem_answer(struct GuiButton *gbtn);
void frontnet_net_serial_start(struct GuiButton *gbtn);
void frontnet_net_serial_start_maintain(struct GuiButton *gbtn);
void gui_load_game(struct GuiButton *gbtn);
void gui_load_game_maintain(struct GuiButton *gbtn);
void gui_area_scroll_window(struct GuiButton *gbtn);
void gui_go_to_event(struct GuiButton *gbtn);
void maintain_zoom_to_event(struct GuiButton *gbtn);
void gui_close_objective(struct GuiButton *gbtn);
void gui_scroll_text_up(struct GuiButton *gbtn);
void gui_scroll_text_down(struct GuiButton *gbtn);
void maintain_scroll_up(struct GuiButton *gbtn);
void maintain_scroll_down(struct GuiButton *gbtn);
void gui_scroll_text_down(struct GuiButton *gbtn);
void choose_hold_audience(struct GuiButton *gbtn);
void choose_armageddon(struct GuiButton *gbtn);
void frontend_load_game_up(struct GuiButton *gbtn);
void frontend_load_game_down(struct GuiButton *gbtn);
void frontend_load_game_up_maintain(struct GuiButton *gbtn);
void frontend_load_game_down_maintain(struct GuiButton *gbtn);
void frontend_load_game_maintain(struct GuiButton *gbtn);
void frontend_draw_games_scroll_tab(struct GuiButton *gbtn);
void frontend_load_game(struct GuiButton *gbtn);
void frontend_draw_load_game_button(struct GuiButton *gbtn);
void frontend_start_new_game(struct GuiButton *gbtn);
void frontend_load_continue_game(struct GuiButton *gbtn);
void frontend_continue_game_maintain(struct GuiButton *gbtn);
void frontend_main_menu_load_game_maintain(struct GuiButton *gbtn);
void frontend_main_menu_netservice_maintain(struct GuiButton *gbtn);
void frontend_main_menu_highscores_maintain(struct GuiButton *gbtn);
void gui_previous_battle(struct GuiButton *gbtn);
void gui_next_battle(struct GuiButton *gbtn);
void gui_get_creature_in_battle(struct GuiButton *gbtn);
void gui_go_to_person_in_battle(struct GuiButton *gbtn);
void gui_setup_friend_over(struct GuiButton *gbtn);
void gui_area_friendly_battlers(struct GuiButton *gbtn);
void gui_setup_enemy_over(struct GuiButton *gbtn);
void gui_area_enemy_battlers(struct GuiButton *gbtn);
void select_resurrect_creature(struct GuiButton *gbtn);
void maintain_resurrect_creature_select(struct GuiButton *gbtn);
void draw_resurrect_creature(struct GuiButton *gbtn);
void select_resurrect_creature_up(struct GuiButton *gbtn);
void select_resurrect_creature_down(struct GuiButton *gbtn);
void maintain_resurrect_creature_scroll(struct GuiButton *gbtn);
void select_transfer_creature(struct GuiButton *gbtn);
void draw_transfer_creature(struct GuiButton *gbtn);
void maintain_transfer_creature_select(struct GuiButton *gbtn);
void select_transfer_creature_up(struct GuiButton *gbtn);
void select_transfer_creature_down(struct GuiButton *gbtn);
void maintain_transfer_creature_scroll(struct GuiButton *gbtn);

void frontend_load_data_from_cd(void);
void frontend_load_data_reset(void);
void frontend_save_continue_game(long lv_num, int a2);
void draw_map_parchment(void);
void gui_area_null(struct GuiButton *gbtn);
void draw_load_button(struct GuiButton *gbtn);
void gui_activity_background(struct GuiMenu *gmnu);
void gui_pretty_background(struct GuiMenu *gmnu);
void frontend_draw_large_menu_button(struct GuiButton *gbtn);
void frontend_copy_mnu_background(struct GuiMenu *gmnu);
void frontend_copy_background(void);
void frontend_copy_background_at(int rect_x,int rect_y,int rect_w,int rect_h);
void parchment_copy_background_at(int rect_x,int rect_y,int rect_w,int rect_h);
void gui_round_glass_background(struct GuiMenu *gmnu);
void gui_creature_query_background1(struct GuiMenu *gmnu);
void gui_creature_query_background2(struct GuiMenu *gmnu);
void maintain_event_button(struct GuiButton *gbtn);
void reset_scroll_window(struct GuiMenu *gmnu);
void init_load_menu(struct GuiMenu *gmnu);
void init_save_menu(struct GuiMenu *gmnu);
void init_video_menu(struct GuiMenu *gmnu);
void init_audio_menu(struct GuiMenu *gmnu);
void frontend_init_options_menu(struct GuiMenu *gmnu);
void frontend_load_game_maintain(struct GuiButton *gbtn);
void frontnet_service_select(struct GuiButton *gbtn);
void frontnet_service_up_maintain(struct GuiButton *gbtn);
void frontnet_service_down_maintain(struct GuiButton *gbtn);
void frontnet_service_up(struct GuiButton *gbtn);
void frontnet_service_down(struct GuiButton *gbtn);
void frontnet_service_maintain(struct GuiButton *gbtn);
void frontnet_draw_service_button(struct GuiButton *gbtn);
long menu_id_to_number(short menu_id);
char update_menu_fade_level(struct GuiMenu *gmnu);
void draw_menu_buttons(struct GuiMenu *gmnu);
char create_menu(struct GuiMenu *mnu);
void do_button_release_actions(struct GuiButton *gbtn, unsigned char *, Gf_Btn_Callback callback);
void draw_gui(void);
void init_gui(void);
void reinit_all_menus(void);
void kill_button_area_input(void);
void kill_menu(struct GuiMenu *gmnu);

void spell_lost_first_person(struct GuiButton *gbtn);
void gui_turn_on_autopilot(struct GuiButton *gbtn);
void gui_set_autopilot(struct GuiButton *gbtn);

int frontend_set_state(long nstate);
void frontstats_initialise(void);
int get_startup_menu_state(void);
void frontend_input(void);
void turn_on_menu(short idx);
void turn_off_menu(short mnu_idx);
void turn_off_query_menus(void);
short turn_off_all_window_menus(void);
short turn_off_all_bottom_menus(void);
void turn_on_main_panel_menu(void);
void turn_off_all_panel_menus(void);
void set_menu_mode(long mnu_idx);
void frontend_update(short *finish_menu);
short frontend_draw(void);
short menu_is_active(short idx);
short a_menu_window_is_active(void);
void turn_on_event_info_panel_if_necessary(unsigned short evnt_idx);
void get_player_gui_clicks(void);
char game_is_busy_doing_gui(void);
void turn_off_event_box_if_necessary(long plridx, char val);
void set_gui_visible(short visible);
void toggle_gui(void);
unsigned long toggle_status_menu(short visib);
void toggle_gui_overlay_map(void);
void display_objectives(long a1,long a2,long a3);


/******************************************************************************/
#ifdef __cplusplus
}
#endif
#endif
