/******************************************************************************/
// Free implementation of Bullfrog's Dungeon Keeper strategy game.
/******************************************************************************/
/** @file packets.h
 *     Header file for packets.c.
 * @par Purpose:
 *     Packet processing routines.
 * @par Comment:
 *     Just a header file - #defines, typedefs, function prototypes etc.
 * @author   Tomasz Lis
 * @date     30 Jan 2009 - 11 Feb 2009
 * @par  Copying and copyrights:
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 */
/******************************************************************************/

#ifndef DK_PACKETS_H
#define DK_PACKETS_H

#include "bflib_basics.h"
#include "globals.h"

#ifdef __cplusplus
extern "C" {
#endif
/******************************************************************************/
enum TbPacketAction {
        PckA_None           =    0,
        PckA_PlyrMsgBegin   =   13,
        PckA_PlyrMsgEnd     =   14,
        PckA_ToggleLights   =   20,
        PckA_SwitchScrnRes  =   21,
        PckA_TogglePause    =   22,
        PckA_BookmarkLoad   =   26,
        PckA_SetGammaLevel  =   27,
        PckA_SetMinimapConf =   28,
        PckA_SetPlyrState   =   36,
        PckA_CheatRevealMap =   63,
        PckA_SpellCTADis    =   89,
        PckA_PlyrFastMsg    =  108,
        PckA_SpellSOEDis    =  114,
        PckA_PlyrToggleAlly =  118,
        PckA_PlyrMsgChar    =  121,
};

enum TbPacketControl {
        PCtr_None           = 0x0000,
        PCtr_LBtnClick      = 0x0100,
        PCtr_RBtnClick      = 0x0200,
        PCtr_LBtnHeld       = 0x0400,
        PCtr_RBtnHeld       = 0x0800,
        PCtr_LBtnRelease    = 0x1000,
        PCtr_RBtnRelease    = 0x2000,
        PCtr_MapCoordsValid = 0x8000,
};

#define PCtr_LBtnAnyAction (PCtr_LBtnClick | PCtr_LBtnHeld | PCtr_LBtnRelease)
#define PCtr_RBtnAnyAction (PCtr_RBtnClick | PCtr_RBtnHeld | PCtr_RBtnRelease)

#ifdef __cplusplus
#pragma pack(1)
#endif

struct Packet { // sizeof = 0x11 (17)
    int field_0;
    TbChecksum chksum;
    unsigned char action;
    unsigned short field_6;
    unsigned short field_8;
    short field_A;
    short field_C;
    short field_E;
    unsigned char field_10;
    };

struct PacketSaveHead { // sizeof=0xF (15)
unsigned int field_0;
    unsigned long level_num;
unsigned int field_8;
    unsigned char field_C;
    unsigned char field_D;
    TbChecksum chksum;
    };

#ifdef __cplusplus
#pragma pack()
#endif

/******************************************************************************/
/******************************************************************************/
void set_packet_action(struct Packet *pckt, unsigned char pcktype, unsigned short par1, unsigned short par2, unsigned short par3, unsigned short par4);
void set_packet_control(struct Packet *pckt, unsigned long flag);
void unset_packet_control(struct Packet *pckt, unsigned long flag);
short set_packet_pause_toggle(void);
void process_dungeon_control_packet_clicks(long idx);
void process_players_dungeon_control_packet_action(long idx);
void process_players_creature_control_packet_control(long idx);
void process_players_creature_passenger_packet_action(long idx);
void process_players_creature_control_packet_action(long idx);
void process_map_packet_clicks(long idx);
void process_pause_packet(long a1, long a2);
void process_quit_packet(struct PlayerInfo *player, short complete_quit);
void process_packets(void);
void clear_packets(void);
unsigned long compute_players_checksum(void);
short checksums_different(void);
void post_init_packets(void);

void open_new_packet_file_for_save(void);
void load_packets_for_turn(long nturn);
void open_packet_file_for_load(char *fname);
short save_packets(void);
void close_packet_file(void);
/******************************************************************************/
#ifdef __cplusplus
}
#endif
#endif
