//
// CActionStack
// haleyjd
//
// Implements a really basic class to track undo and redo actions.
//

#ifndef ACTIONSTACK_H__
#define ACTIONSTACK_H__

class CActionStack
{
public:
   enum
   {
      ACTION_EDIT,
      ACTION_ADD,
      ACTION_DELETE,
   };

   struct ActionItem
   {
      int    type;
      int    index;
      string value;
   };

protected:
   vector<ActionItem> undoActions;
   vector<ActionItem> redoActions;

public:
   CActionStack() : undoActions(), redoActions() {}

   int GetNumUndoActions() const { return undoActions.size(); }
   int GetNumRedoActions() const { return redoActions.size(); }

   bool GetUndoAction(ActionItem &aItem)
   {
      bool ret = false;
      int  num = undoActions.size();

      if(num > 0)
      {
         aItem = undoActions.at(num - 1);
         undoActions.pop_back();
         ret = true;
      }

      return ret;
   }

   bool GetRedoAction(ActionItem &aItem)
   {
      bool ret = false;
      int  num = redoActions.size();

      if(num > 0)
      {
         aItem = redoActions.at(num - 1);
         redoActions.pop_back();
         ret = true;
      }

      return ret;
   }

   void AddUndoAction(const ActionItem &aItem, bool newAction)
   {
      undoActions.push_back(aItem);

      // when a new action has occurred, the redo stack is cleared
      if(newAction)
         redoActions.erase(redoActions.begin(), redoActions.end());
   }

   void AddRedoAction(const ActionItem &aItem)
   {
      redoActions.push_back(aItem);
   }

   void EraseAll()
   {
      undoActions.erase(undoActions.begin(), undoActions.end());
      redoActions.erase(redoActions.begin(), redoActions.end());
   }
};

#endif

// EOF

