// DKText32Doc.cpp : implementation of the CDKText32Doc class
//

#include "stdafx.h"
#include "DKText32.h"

#include "DKText32Doc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDKText32Doc

IMPLEMENT_DYNCREATE(CDKText32Doc, CDocument)

BEGIN_MESSAGE_MAP(CDKText32Doc, CDocument)
	//{{AFX_MSG_MAP(CDKText32Doc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDKText32Doc construction/destruction

CDKText32Doc::CDKText32Doc() : messages(), actionStack()
{
   // haleyjd: one-time construction code
   numMessages = 0;
}

CDKText32Doc::~CDKText32Doc()
{
}

BOOL CDKText32Doc::OnNewDocument()
{
   if(!CDocument::OnNewDocument())
      return FALSE;
   
   // haleyjd: reinitialization code
   messages.erase(messages.begin(), messages.end());
   numMessages = 0;
   actionStack.EraseAll();
   
   return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CDKText32Doc serialization

// haleyjd: retarded Visual C++ template bug. You can't use the syntax
// vector<string>::iterator because the resulting type string is too complex
// for this braindead compiler. This typedef, for some unimaginable reason, 
// works just fine despite meaning the exact same thing.

typedef vector<string> StringVector;

void CDKText32Doc::Serialize(CArchive &ar)
{
   if(ar.IsStoring())
   {
      StringVector::iterator it;

      // haleyjd: store the messages
      for(it = messages.begin(); it != messages.end(); ++it)
      {
         unsigned int len = it->length() + 1;
         char *buf = new char [len];

         // 05/24/07: must copy to a temporary buffer and then convert 
         // the strings back to OEM (DOS) character set.
         it->copy(buf, len - 1);
         buf[len - 1] = '\0';

         CharToOemBuff(buf, buf, len);

         // in case you're wondering, ar.WriteString won't work
         // because it doesn't write out the null byte :P
         ar.Write(buf, len);

         delete [] buf;
      }
   }
   else
   {
      char c;
      string m;

      // haleyjd: load the messages
      while(ar.Read(&c, 1))
      {
         OemToCharBuff(&c, &c, 1); // 05/24/07: must convert from DOS chars!

         if(c == '\0') // end of current string
         {
            messages.push_back(m);
            m.erase();
         }
         else
            m.append(1, c);
      }

      numMessages = messages.size();
      actionStack.EraseAll();        // clear the undo/redo stack on doc load
   }
}

/////////////////////////////////////////////////////////////////////////////
// CDKText32Doc diagnostics

#ifdef _DEBUG
void CDKText32Doc::AssertValid() const
{
	CDocument::AssertValid();
}

void CDKText32Doc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// haleyjd: custom methods

//
// CDKText32Doc::GetMessageAt
//
// Tries to get and return a const pointer to the message at the given index.
// It will catch the exception if vector::at throws, but you do NOT want this
// to happen because it will usually cause the view to enter an infinite loop
// attempting to display the invalid string. So in short, do range checking.
//
const char *CDKText32Doc::GetMessageAt(int i) const
{
   const char *ret = "";

   try
   {
      ret = messages.at(i).c_str();
   }
   catch(...)
   {
      char msg[128];
      _snprintf(msg, sizeof(msg), "Error: Couldn't get message %d", i);
      AfxMessageBox(msg, MB_OK | MB_ICONSTOP);
   }

   return ret;
}

//
// CDKText32Doc::SetMessageAt
//
// The complement of GetMessageAt. The same warning applies to this routine.
//
void CDKText32Doc::SetMessageAt(int i, const char *c)
{
   try
   {
      CActionStack::ActionItem aItem;

      aItem.type  = CActionStack::ACTION_EDIT;
      aItem.index = i;
      aItem.value = messages.at(i);

      messages.at(i).assign(c);
      SetModifiedFlag();

      actionStack.AddUndoAction(aItem, true);
   }
   catch(...)
   {
      char msg[128];
      _snprintf(msg, sizeof(msg), "Error: Couldn't set message %d", i);
      AfxMessageBox(msg, MB_OK | MB_ICONSTOP);
   }
}

//
// CDKText32Doc::AddMessageEnd
//
// Adds a new message string to the end of the list.
//
void CDKText32Doc::AddMessageEnd(const char *c)
{
   CActionStack::ActionItem aItem;

   messages.push_back(c);
   ++numMessages;
   SetModifiedFlag();

   aItem.type  = CActionStack::ACTION_ADD;
   aItem.index = numMessages - 1;
   aItem.value = c;

   actionStack.AddUndoAction(aItem, true);
}

//
// CDKText32Doc::DelMessageEnd
//
// If possible, the last message will be deleted.
//
void CDKText32Doc::DelMessageEnd()
{
   if(messages.size() > 0)
   {
      CActionStack::ActionItem aItem;

      // save value of string in undo item
      aItem.value = messages.at(numMessages - 1);

      messages.pop_back();
      --numMessages;
      SetModifiedFlag();

      aItem.type  = CActionStack::ACTION_DELETE;
      aItem.index = numMessages;

      actionStack.AddUndoAction(aItem, true);
   }
}

//
// CDKText32Doc::ReverseAction
//
// Implements the core of the undo/redo system, using the CActionStack
// class. All undos and redos are processed by this function, via calls
// issued by the view. After an undo action is executed, it becomes a 
// redo action.  Redo actions become undo actions, but the redo stack
// is not cleared in this situation since the action is not new. There
// are a lot of assertions here because I don't trust myself :P
//
int CDKText32Doc::ReverseAction(int type)
{
   CActionStack::ActionItem aItem;
   bool actionRet;
   int ret = 0; // returns index of message on which to set focus
   string tmp;

   if(type == REV_UNDO)
      actionRet = actionStack.GetUndoAction(aItem);
   else
      actionRet = actionStack.GetRedoAction(aItem);

   if(!actionRet) // no action to undo/redo?
      return -1;

   ret = aItem.index;

   switch(aItem.type)
   {
   case CActionStack::ACTION_EDIT:
      ASSERT(aItem.index < messages.size());
      tmp = messages.at(aItem.index);         // save current value
      messages.at(aItem.index) = aItem.value; // set message back to previous value
      aItem.value = tmp;                      // change the item to store newer value
      break;
   case CActionStack::ACTION_ADD:
      ASSERT(messages.size() > 0);
      messages.pop_back();
      --numMessages;
      aItem.type = CActionStack::ACTION_DELETE; // reverse action type
      --ret; // this message was deleted, so highlight the next message
      break;
   case CActionStack::ACTION_DELETE:
      ASSERT(messages.size() == aItem.index);
      messages.push_back(aItem.value);
      ++numMessages;
      aItem.type = CActionStack::ACTION_ADD;    // reverse action type
      break;
   default:
      ASSERT(0);
      break;
   }

   // add the action back as the opposite action type
   if(type == REV_UNDO)
      actionStack.AddRedoAction(aItem);
   else
      actionStack.AddUndoAction(aItem, false); // do not clear redo stack

   SetModifiedFlag();

   return ret;
}

//
// CDKText32Doc::GetNumUndoActions
//
// Returns the current number of objects on the undo stack.
//
int CDKText32Doc::GetNumUndoActions() const
{
   return actionStack.GetNumUndoActions();
}

//
// CDKText32Doc::GetNumRedoActions
//
// Returns the current number of objects on the redo stack.
//
int CDKText32Doc::GetNumRedoActions() const
{
   return actionStack.GetNumRedoActions();
}

/////////////////////////////////////////////////////////////////////////////
// CDKText32Doc commands


BOOL CDKText32Doc::OnOpenDocument(LPCTSTR lpszPathName) 
{
   // haleyjd: reinitialization code
   messages.erase(messages.begin(), messages.end());
   numMessages = 0;
   actionStack.EraseAll();

   if(!CDocument::OnOpenDocument(lpszPathName))
      return FALSE;
   
   return TRUE;
}
