// DKText32Doc.h : interface of the CDKText32Doc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_DKTEXT32DOC_H__F23C593F_0AF2_4BB1_8CA3_A842A87ED8EF__INCLUDED_)
#define AFX_DKTEXT32DOC_H__F23C593F_0AF2_4BB1_8CA3_A842A87ED8EF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

using std::string;
using std::vector;

// haleyjd: undo/redo action stack
#include "ActionStack.h"

class CDKText32Doc : public CDocument
{
protected: // create from serialization only
	CDKText32Doc();
	DECLARE_DYNCREATE(CDKText32Doc)

// Attributes
public:
	int numMessages;

protected:
	vector<string> messages;
	CActionStack actionStack;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDKText32Doc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CDKText32Doc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

        // haleyjd
        const char *GetMessageAt(int i) const;
        void SetMessageAt(int i, const char *c);
        void AddMessageEnd(const char *c);
        void DelMessageEnd();
        int  GetNumUndoActions() const; // reflected from action stack
        int  GetNumRedoActions() const; // reflected from action stack

        enum
        {
           REV_UNDO,
           REV_REDO
        };

        int ReverseAction(int type);

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CDKText32Doc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DKTEXT32DOC_H__F23C593F_0AF2_4BB1_8CA3_A842A87ED8EF__INCLUDED_)
