// DKText32View.cpp : implementation of the CDKText32View class
//

#include "stdafx.h"
#include "DKText32.h"

#include "DKText32Doc.h"
#include "DKText32View.h"
#include "MsgEditDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDKText32View

IMPLEMENT_DYNCREATE(CDKText32View, CListView)

BEGIN_MESSAGE_MAP(CDKText32View, CListView)
	//{{AFX_MSG_MAP(CDKText32View)
	ON_NOTIFY_REFLECT(LVN_GETDISPINFO, OnGetDispInfo)
	ON_WM_LBUTTONDBLCLK()
	ON_UPDATE_COMMAND_UI(ID_EDIT_EDITMESSAGE, OnUpdateEditMessage)
	ON_COMMAND(ID_EDIT_EDITMESSAGE, OnEditMessage)
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, OnUpdateEditPaste)
	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CUT, OnUpdateEditCut)
	ON_COMMAND(ID_EDIT_ADDMESSAGE, OnEditAddMessage)
	ON_COMMAND(ID_EDIT_DELETELAST, OnEditDeleteLast)
	ON_UPDATE_COMMAND_UI(ID_EDIT_DELETELAST, OnUpdateEditDeleteLast)
	ON_COMMAND(ID_EDIT_UNDO, OnEditUndo)
	ON_UPDATE_COMMAND_UI(ID_EDIT_UNDO, OnUpdateEditUndo)
	ON_COMMAND(ID_EDIT_REDO, OnEditRedo)
	ON_UPDATE_COMMAND_UI(ID_EDIT_REDO, OnUpdateEditRedo)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CListView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CListView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CListView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDKText32View construction/destruction

CDKText32View::CDKText32View()
{
	// TODO: add construction code here

}

CDKText32View::~CDKText32View()
{
}

BOOL CDKText32View::PreCreateWindow(CREATESTRUCT& cs)
{
   // TODO: Modify the Window class or styles here by modifying
   //  the CREATESTRUCT cs

   cs.style |= (LVS_REPORT | LVS_SHOWSELALWAYS | LVS_OWNERDATA | LVS_SINGLESEL);
   
   return CListView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CDKText32View drawing

void CDKText32View::OnDraw(CDC* pDC)
{
	CDKText32Doc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here
}

void CDKText32View::OnInitialUpdate()
{
   static bool firstTime = true;

   CListView::OnInitialUpdate();
   
   // haleyjd: first time: setup columns
   if(firstTime == true)
   {
      CRect r;
      LVCOLUMN col;
      int scrollwidth, listwidth;
      CListCtrl &list = GetListCtrl();
      DWORD exStyle   = list.GetExtendedStyle();

      firstTime = false;

      col.mask    = LVCF_TEXT | LVCF_WIDTH;
      col.cx      = 50;
      col.pszText = "Number";
      list.InsertColumn(0, &col);

      // weird hack to get right-justification
      col.mask    = LVCF_FMT;
      col.fmt     = LVCFMT_RIGHT;
      list.SetColumn(0, &col);
      
      // calculate length of second column
      // assume there will always be a scrollbar; this avoids any trouble
      // when there is one, which will be 99% of the time.
      list.GetClientRect(&r);
      scrollwidth = GetSystemMetrics(SM_CXVSCROLL);
      listwidth   = r.Width() - scrollwidth - 50;
      
      col.mask    = LVCF_TEXT | LVCF_WIDTH;
      col.pszText = "Message";
      col.cx      = listwidth;
      list.InsertColumn(1, &col);
      
      // also set extended styles here; for some reason this doesn't work
      // from PreCreateWindow o_O
      list.SetExtendedStyle(exStyle | LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT);
   }

   // haleyjd: initialize printing
   m_Print.SetListCtrl(&GetListCtrl());
   m_Print.SetListView(this);
   m_Print.SetAppName(AfxGetAppName());
   m_Print.SetDocTitle(GetDocument()->GetTitle());
}

/////////////////////////////////////////////////////////////////////////////
// CDKText32View printing

BOOL CDKText32View::OnPreparePrinting(CPrintInfo* pInfo)
{
   // haleyjd:
   m_Print.OnPreparePrinting(pInfo);
   return DoPreparePrinting(pInfo);
}

void CDKText32View::OnBeginPrinting(CDC *pDC, CPrintInfo *pInfo)
{
   // haleyjd:
   m_Print.OnBeginPrinting(pDC, pInfo);
}

void CDKText32View::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
   m_Print.OnPrint(pDC, pInfo);
}

void CDKText32View::OnEndPrinting(CDC *pDC, CPrintInfo *pInfo)
{
   // haleyjd:
   m_Print.OnEndPrinting(pDC, pInfo);
}

/////////////////////////////////////////////////////////////////////////////
// CDKText32View diagnostics

#ifdef _DEBUG
void CDKText32View::AssertValid() const
{
	CListView::AssertValid();
}

void CDKText32View::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}

CDKText32Doc* CDKText32View::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDKText32Doc)));
	return (CDKText32Doc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// haleyjd: custom methods

void CDKText32View::EditMessage()
{
   int idx, ret;

   if((idx = GetListCtrl().GetNextItem(-1, LVNI_SELECTED)) >= 0)
   {
      CMsgEditDialog dlg;

      dlg.m_strMessage = GetDocument()->GetMessageAt(idx);

      ret = dlg.DoModal();

      switch(ret)
      {
      case IDOK: // on ok, save the new string back into the document
         GetDocument()->SetMessageAt(idx, dlg.m_strMessage);
         Invalidate();
         break;
      default:
         break;
      }
   }
}

void CDKText32View::UpdateUI(CCmdUI *pCmdUI)
{
   BOOL itemSelected;

   // enable or disable UI items based on whether or not a list view item
   // is selected.
   itemSelected = (GetListCtrl().GetNextItem(-1, LVNI_SELECTED) >= 0);

   pCmdUI->Enable(itemSelected);
}

bool CDKText32View::CopyToClipboard(int idx)
{
   int len;
   HGLOBAL    hglbCopy;
   char       *lockPtr;
   const char *msg;
   
   // haleyjd: implement the copy command
   msg = GetDocument()->GetMessageAt(idx);
   len = strlen(msg) + 1;
   
   // open the clipboard
   if(!OpenClipboard())
      return false;

   // empty any current contents
   if(!EmptyClipboard())
      return false;

   // allocate global memory object
   if((hglbCopy = GlobalAlloc(GMEM_SHARE | GMEM_MOVEABLE, len)) == NULL)
   {
      CloseClipboard();
      return false;
   }

   // lock the memory and copy the string to it
   lockPtr = (char *)GlobalLock(hglbCopy);
   strncpy(lockPtr, msg, len);
   GlobalUnlock(hglbCopy);

   // throw this crap onto the clipboard
   // (Shouldn't this be the ONLY thing necessary? Why isn't this crap
   //  encapsulated by MFC??? >_< )

   SetClipboardData(CF_TEXT, hglbCopy);

   CloseClipboard();

   return true;
}

void CDKText32View::ReverseDocAction(int type)
{
   int itemChanged;
   CListCtrl &list = GetListCtrl();

   // perform the undo or redo action here (system is symmetric by design ;)

   itemChanged = GetDocument()->ReverseAction(type);
   list.SetItemCount(GetDocument()->numMessages);

   // if a valid index is returned, we can set focus to the altered item
   if(itemChanged >= 0)
   {
      list.EnsureVisible(itemChanged, FALSE);
      list.SetItemState(itemChanged, LVIS_SELECTED | LVIS_FOCUSED,
                        LVIS_SELECTED | LVIS_FOCUSED);
   }

   Invalidate();
}

/////////////////////////////////////////////////////////////////////////////
// CDKText32View message handlers


void CDKText32View::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
   CListView::OnUpdate(pSender, lHint, pHint);

   // haleyjd: on updates, sync the number of list view items with the
   // number of messages in the current document.
   GetListCtrl().SetItemCount(GetDocument()->numMessages);
}

void CDKText32View::OnGetDispInfo(NMHDR *pNMHDR, LRESULT *pResult) 
{
   LV_DISPINFO *pDispInfo = (LV_DISPINFO *)pNMHDR;
   LV_ITEM *pItem= &(pDispInfo)->item;
   int iItemIndex= pItem->iItem;
   char numstr[33];
   const char *str;

   // haleyjd: the list view items are user-owned, so the text must be
   // retrieved here in response to a DISPINFO event. This allows max
   // efficiency and requires no duplication of the document's data in
   // the list control.

   if(pItem->mask & LVIF_TEXT)
   {
      switch(pItem->iSubItem)
      {
      case 0: // number
         itoa(iItemIndex, numstr, 10);
         str = numstr;
         break;
      case 1: // message
         str = GetDocument()->GetMessageAt(iItemIndex);
         break;
      }
      lstrcpyn(pItem->pszText, str, pItem->cchTextMax);
   }

   *pResult = 0;
}

void CDKText32View::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
   //CListView::OnLButtonDblClk(nFlags, point);
   EditMessage();
}

void CDKText32View::OnUpdateEditMessage(CCmdUI* pCmdUI) 
{
   UpdateUI(pCmdUI);
}

void CDKText32View::OnEditMessage() 
{
   EditMessage();
}

void CDKText32View::OnContextMenu(CWnd* pWnd, CPoint point) 
{
   // haleyjd: display edit menu as context menu
   CMenu *menu;
   CWnd  *wnd;

   if(point.x == -1 && point.y == -1)
   {
      // Keystroke invocation
      CRect rect;
      
      GetClientRect(rect);
      ClientToScreen(rect);
      
      point = rect.TopLeft();
      point.Offset(5, 5);
   }

   wnd  = theApp.GetMainWnd();
   menu = wnd->GetMenu()->GetSubMenu(1);
   ASSERT(menu);

   menu->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_LEFTBUTTON, 
                        point.x, point.y, wnd);
}

void CDKText32View::OnEditCopy() 
{
   int idx;

   // a message must be selected to copy
   if((idx = GetListCtrl().GetNextItem(-1, LVNI_SELECTED)) < 0)
      return;

   CopyToClipboard(idx);
}

void CDKText32View::OnUpdateEditCopy(CCmdUI* pCmdUI) 
{
   UpdateUI(pCmdUI);
}

void CDKText32View::OnEditPaste() 
{
   int idx;
   HGLOBAL hMem;

   // a message must be selected to paste
   if((idx = GetListCtrl().GetNextItem(-1, LVNI_SELECTED)) < 0)
      return;

   if(!OpenClipboard())
      return;

   // if the clipboard has text format data, lock it and copy it to the 
   // selected message.
   if((hMem = GetClipboardData(CF_TEXT)))
   {
      const char *lockPtr = (const char *)GlobalLock(hMem);

      GetDocument()->SetMessageAt(idx, lockPtr);

      GlobalUnlock(hMem);

      // document has been modified, force update
      Invalidate();
   }

   CloseClipboard();
}

void CDKText32View::OnUpdateEditPaste(CCmdUI* pCmdUI) 
{
   UpdateUI(pCmdUI);
}

void CDKText32View::OnEditCut() 
{
   int idx;

   // a message must be selected to cut
   if((idx = GetListCtrl().GetNextItem(-1, LVNI_SELECTED)) < 0)
      return;

   if(CopyToClipboard(idx))
   {
      // clear message if copy was successful, and force redraw
      GetDocument()->SetMessageAt(idx, "");
      Invalidate();
   }
}

void CDKText32View::OnUpdateEditCut(CCmdUI* pCmdUI) 
{
   UpdateUI(pCmdUI);
}

void CDKText32View::OnEditAddMessage() 
{
   int ret, iNum;
   CMsgEditDialog dlg;
   CListCtrl &list = GetListCtrl();
   
   dlg.m_strMessage = "";
   
   ret = dlg.DoModal();
   
   switch(ret)
   {
   case IDOK: // on ok, save the new string into the document
      GetDocument()->AddMessageEnd(dlg.m_strMessage);
      iNum = GetDocument()->numMessages;
      list.SetItemCount(iNum);
      list.EnsureVisible(iNum - 1, FALSE);
      list.SetItemState(iNum - 1, LVIS_SELECTED | LVIS_FOCUSED,
                        LVIS_SELECTED | LVIS_FOCUSED);
      Invalidate();
      break;
   default:
      break;
   }
}

void CDKText32View::OnEditDeleteLast() 
{
   int ret, iNum;
   char msg[128];

   iNum = GetDocument()->numMessages - 1;

   _snprintf(msg, sizeof(msg),
             "Are you sure you want to delete message #%d?", iNum);
   
   ret = MessageBox(msg, "Delete Message", MB_YESNO | MB_ICONQUESTION);

   if(ret == IDYES)
   {
      CListCtrl &list = GetListCtrl();
      CSize sz;

      // make sure the item to be deleted is NOT selected or focused
      list.SetItemState(iNum, 0, LVIS_SELECTED | LVIS_FOCUSED);
      
      GetDocument()->DelMessageEnd();
      iNum = GetDocument()->numMessages;
      list.SetItemCount(iNum);
      list.EnsureVisible(iNum - 1, FALSE);
      list.SetItemState(iNum - 1, LVIS_SELECTED | LVIS_FOCUSED,
                        LVIS_SELECTED | LVIS_FOCUSED);
      Invalidate();
   }
}

void CDKText32View::OnUpdateEditDeleteLast(CCmdUI* pCmdUI) 
{
   // if there is 1 or more message, allow it to be deleted
   pCmdUI->Enable((GetDocument()->numMessages > 0));
}

void CDKText32View::OnEditUndo() 
{
   ReverseDocAction(CDKText32Doc::REV_UNDO);
}

void CDKText32View::OnUpdateEditUndo(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable((GetDocument()->GetNumUndoActions() != 0));
}

void CDKText32View::OnEditRedo() 
{
   ReverseDocAction(CDKText32Doc::REV_REDO);
}

void CDKText32View::OnUpdateEditRedo(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable((GetDocument()->GetNumRedoActions() != 0));
}
